dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/cruise", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 4, 240, 400, "assets/images/table/cruise", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 1;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2


guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female01;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 7, 22000);

-- Group 3


guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 9, 55000);


-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 12, 100000);

-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestTissue = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 14, 120000);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 16, 135000);



LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 90000 );


LManager:AdjustGuestTolerance(130);



-- Set up the Level Settings
LManager:SetLevelNumber(3,1);
LManager:SetLevelScores(5300, 7500);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_3.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );